/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet;

import com.ibm.hwmca.base.managed.BaseTaskKeys;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletAuthorized {
    private static final String TRACE_MASKT = "XFRMSAUT";
    private static final String TRACE_MASKF = "XFRMSAUF";
    private static final String TRACE_MASKD = "XFRMSAUD";

    public static boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, String key) throws IOException {
        boolean isAuth = false;
        Trace.trace(TRACE_MASKF, "-> ServletAuthorized.isAuthorized() for key=" + key);
        try {
            ObjectId oid = BaseTaskKeys.getObjectIdFromKey(key);
            Client authClient = new Client("com.ibm.hwmca.fw.servlet.support.SupportAuthTasklet", oid);
            TaskletResponse resp = authClient.init();
            Boolean auth = (Boolean)resp.getData("authorized");
            if (auth != null) {
                isAuth = auth;
            }
            if (!isAuth) {
                response.sendError(401, "Not authorized to perform request.");
            }
        }
        catch (TaskletException e) {
            isAuth = false;
            Trace.trace(TRACE_MASKF, e);
            response.sendError(500, "Internal error: " + e);
        }
        Trace.trace(TRACE_MASKF, "<- ServletAuthorized.isAuthorized(" + isAuth + ") key=" + key);
        return isAuth;
    }
}

